<?php
/**
 * The template for displaying archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each one. For example, tag.php (Tag archives),
 * category.php (Category archives), author.php (Author archives), etc.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Fifteen
 * @since Twenty Fifteen 1.0
 */

get_header(); ?>
<div id="wrapper" class="clearfix">

	<div id="primary" class="content-area standard clearfix">
		<main id="main" class="site-main" role="main">
		
			<header class="page-header centertext">
				<?php
					the_archive_title( '<h1 class="page-title heavyweight">', '</h1>' );
					the_archive_description( '<div class="taxonomy-description">', '</div>' );
					
					// Author bio.
					if ( is_author() && get_the_author_meta( 'description' ) ) :
						get_template_part( 'author-bio' );
					endif;
				?>
			</header><!-- .page-header -->
			
				<?php 
				// Previous/next page navigation.
					the_posts_pagination( array(
						'prev_text'          => __( 'Previous page', 'twentyfifteen' ),
						'next_text'          => __( 'Next page', 'twentyfifteen' ),
						'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'twentyfifteen' ) . ' </span>',
					) );
				?>
		
				<!-- Shows Custom Post Type "Work" First, then "Post" -->
				<?php if ( have_posts() ) { ?>
					<div class="work-items-wrap clearfix">
						<h2 class="archive-section-title first">Work Projects</h2>
						<?php while ( have_posts() ) {
						the_post();

							if ( $post->post_type == 'work' ) {
								// Output posts from your custom post type ?>
								<div class="work-item-wrap">
									<div class="work-item">
										<div class="image-inner">
											<a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_post_thumbnail('card-thumbnail'); ?></a>
											<div class="work-item-inside">
											<?php
												if ( is_single() ) :
													the_title( '<h1 class="entry-title">', '</h1>' );
												else :
													the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
												endif;
											?>
											<!-- <div class="org-name">< ?php echo get_the_term_list( $post->ID, 'organization', '', ', ', '' ); ?></div> -->
											<div class="card-tags"><?php the_tags('', ' &nbsp;&middot;&nbsp; ' ); ?></div>
											<div class="short-desc"><?php echo the_excerpt(); ?></div>
											<a href="<?php echo esc_url( get_permalink() ); ?>" class="moretag2">View Project <i class="fa fa-chevron-right"></i></a>
											</div>
										</div>
									</div>
								</div>
							<?php	
							} 

						} // endwhile ?>
						
					</div>
					<?php rewind_posts(); // This will reweind posts to the first post so we can rerun the loop ?>

					<div class="post-items-wrap clearfix">
						<h2 class="archive-section-title">Blog Posts</h2>
						<div class="grid-wrap">
						<?php while ( have_posts() ) {
						the_post();

							if ( $post->post_type == 'post' ) {
								// Output posts from the defualt post post type ?>
								
								<div class="box">
									<a class="news-image" href="<?php echo esc_url( get_permalink() ); ?>"><?php the_post_thumbnail(); ?></a>
									<div class="box-text">
										<div class="box-text-inner">
											<?php
												if ( is_single() ) :
													the_title( '<div class="news-title">', '</div>' );
												else :
													the_title( sprintf( '<div class="news-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></div>' );
												endif;
											?>
											<div class="news-date"><?php echo get_the_date(); ?> by <span class="strong"><?php the_author(); ?></span></div>
											<div class="short-desc"><?php the_excerpt(); ?></div>
										</div>
									</div>
								</div>
							<?php 
							} 
						} // endwhile ?>
						</div>
					</div>
				<?php } // endif ?>
				
				<?php 
				// Previous/next page navigation.
					the_posts_pagination( array(
						'prev_text'          => __( 'Previous page', 'twentyfifteen' ),
						'next_text'          => __( 'Next page', 'twentyfifteen' ),
						'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'twentyfifteen' ) . ' </span>',
					) );
				?>
		

		</main><!-- .site-main -->
	</div><!-- .content-area -->
</div>
<?php get_footer(); ?>
