<?php
/**
 * The template part for displaying a message that posts cannot be found
 *
 * Learn more: {@link https://codex.wordpress.org/Template_Hierarchy}
 *
 * @package WordPress
 * @subpackage Twenty_Fifteen
 * @since Twenty Fifteen 1.0
 */
?>

<section class="no-results not-found">
	<header class="page-header centertext">
		<h1 class="page-title heavyweight"><?php _e( 'Nothing Found', 'twentyfifteen' ); ?></h1>
	</header><!-- .page-header -->

	<div class="entry-content">

		<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

			<p class="centertext"><?php printf( __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'twentyfifteen' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>

		<?php elseif ( is_search() ) : ?>

			<p class="centertext"><?php _e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'twentyfifteen' ); ?></p>
			<div class="fill centertext"><?php get_search_form(); ?></div>

		<?php else : ?>

			<p class="centertext"><?php _e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'twentyfifteen' ); ?></p>
			<div class="fill centertext"><?php get_search_form(); ?></div>

		<?php endif; ?>

	</div><!-- .page-content -->
</section><!-- .no-results -->
