<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage Twenty_Fifteen
 * @since Twenty Fifteen 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	

	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<link rel="icon" href="<?php echo get_template_directory_uri(); ?>/favicon.png" type="image/png" />
	<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/favicon.ico" />
	
	<meta name="viewport" content="width=device-width"; >
	
	<!-- Main Stylesheet -->
	<link rel="stylesheet" href="<?php echo get_stylesheet_uri(); ?>">
	
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<!--[if lt IE 9]>
	<script src="<?php echo esc_url( get_template_directory_uri() ); ?>/js/html5.js"></script>
	<![endif]-->
	
	<!-- Fonts -->
	<link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
	<link href="<?php echo esc_url( get_template_directory_uri() ); ?>/fonts/remix/remixicon.css" rel="stylesheet">

	<!-- jQuery & js -->
	<script src="https://code.jquery.com/jquery-3.3.2.min.js" crossorigin="anonymous"></script>
	
	<?php wp_head(); ?>

</head>

<body <?php body_class(); ?> >
<style>

</style>


	<div class="blackcover"></div>
	<div class="lightbox"></div>
	
	<div id="fill">
		<div id="container">
			<i class="ri-home-line"></i> <!-- Example icon, you can remove -->
			
			
