<?php
/**
 * The template for displaying Taxonomies.
 */

get_header(); $term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );

?>

	<div id="wrapper">

		<div id="primary" class="content-area standard clearfix">
					<header class="entry-header">
						<h1 class="entry-title"><?php echo apply_filters( 'the_title', $term->name ); ?></h1>
					</header><!-- .entry-header -->

					<?php if ( have_posts() ) : ?>
						<?php query_posts($query_string . '&orderby=date&order=DSC') ?>


						<?php /* Start the Loop */ ?>
						<?php while ( have_posts() ) : the_post(); ?>

							<?php get_template_part( 'content', 'index' ); ?>

						<?php endwhile; ?>

						<!-- This does not use the function so that the button order is switched -->
						<div id="nav-archive" class="bottom">
							<div class="nav-previous"><?php previous_posts_link( __( '<span class="meta-nav">&larr;</span> Previous Page', 'twentyeleven' ) ); ?></div>
							<div class="nav-next"><?php next_posts_link( __( 'Next Page <span class="meta-nav">&rarr;</span>', 'twentyeleven' ) ); ?></div>
						</div>

					<?php else : ?>

					<article id="post-0" class="post no-results not-found">
						<h4><?php _e( 'Nothing Found', 'twentyeleven' ); ?></h4>

						<div class="entry-content">
							<p><?php _e( 'Apologies, but no results were found for the requested archive. Perhaps searching will help find a related post.', 'twentyeleven' ); ?></p>
						</div><!-- .entry-content -->
					</article><!-- #post-0 -->

					<?php endif; ?>
					<?php wp_reset_query(); ?> <!-- This is necessary to end the query_posts above so that subsequent conditions for other functions still work -->		

		</div><!-- #primary -->

	</div>

<?php get_footer(); ?>
